/*
 * Decompiled with CFR 0.152.
 */
package terrablender.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.BuiltinRegistries;

public class RegistryUtils {
    private static Optional<RegistryAccess> registryAccess = Optional.empty();
    private static List<Consumer<RegistryAccess>> registryAccessCaptureOneShotListeners = Lists.newArrayList();

    public static void captureCurrentRegistryAccess(RegistryAccess access) {
        registryAccess = Optional.of(access);
        registryAccessCaptureOneShotListeners.forEach(listener -> listener.accept(access));
        registryAccessCaptureOneShotListeners.clear();
    }

    public static void clearCurrentRegistryAccess() {
        registryAccess = Optional.empty();
    }

    public static void doWithRegistryAccess(Consumer<RegistryAccess> listener) {
        if (registryAccess.isPresent()) {
            listener.accept(registryAccess.get());
        } else {
            registryAccessCaptureOneShotListeners.add(listener);
        }
    }

    public static RegistryAccess getCurrentRegistryAccess() {
        return registryAccess.orElse(BuiltinRegistries.f_206379_);
    }
}

